using System;
using System.Data;
using System.Data.SqlClient;
using ADDRESS = gov.va.med.vbecs.Common.VbecsTables.Address;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/15/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Address data access layer class.
	///</summary>

	#endregion
	
	public class Address
	{

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="783"> 
		///		<ExpectedInput>Facility Guid</ExpectedInput>
		///		<ExpectedOutput>DataRow of address information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="784"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the address information for a facility
		/// </summary>
		/// <param name="facilityGuid"></param>
		/// <returns></returns>
		public static DataRow GetAddress(System.Guid facilityGuid )
		{
			SqlParameter _prm = new SqlParameter( STOREDPROC.GetAddress.facilityguid, SqlDbType.UniqueIdentifier );
			_prm.Value = facilityGuid;
			
			return Common.StoredProcedure.GetSingleDataRow( STOREDPROC.GetAddress.StoredProcName, _prm );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2061"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable Schema of Address table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2062"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Creates an empty address table of all our relevant fields...
		/// spInsertAddress, spUpdateAddress
		/// </summary>
		/// <returns></returns>
		public static System.Data.DataTable GetEmptyAddressTableSchema(bool isUpdate)
		{
			DataTable dtAddress = new DataTable(ADDRESS.TableName);

			dtAddress.Columns.Add(ADDRESS.AddressGuid, typeof(System.Guid));
			dtAddress.Columns.Add(ADDRESS.AddressLine1, typeof(string));
			dtAddress.Columns.Add(ADDRESS.AddressLine2, typeof(string));
			dtAddress.Columns.Add(ADDRESS.AddressLine3, typeof(string));
			dtAddress.Columns.Add(ADDRESS.AddressZipCode, typeof(string));
			dtAddress.Columns.Add(ADDRESS.AddressCity, typeof(string));
			dtAddress.Columns.Add(ADDRESS.StateCode, typeof(string));

			if (isUpdate)
			{
				dtAddress.Columns.Add(Common.DatabaseConstants.ArtificialColumnNames.AddressRowVersion, typeof(byte[]));
			}

			return dtAddress;
		}
	}
}
